/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.peripheral;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

public interface WorkMonitor {
    public boolean canWork();

    public boolean shouldWork();

    public void trackWork(long var1, TimeUnit var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean runWork(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable should not be null");
        if (!this.canWork()) {
            return false;
        }
        long start = System.nanoTime();
        try {
            runnable.run();
        }
        finally {
            this.trackWork(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        return true;
    }
}

